<?xml version='1.0'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="/iva">
		<iva>
			<TipoIDInformante>R</TipoIDInformante>
			<IdInformante>
				<xsl:value-of select="numeroRuc" />
			</IdInformante>
			<razonSocial>
				<xsl:value-of select="razonSocial" />
			</razonSocial>
			<Anio>
				<xsl:value-of select="anio" />
			</Anio>
			<Mes>
				<xsl:value-of select="mes" />
			</Mes>

			<codigoOperativo>IVA</codigoOperativo>

			<xsl:if test="compras">
				<compras>
					<xsl:for-each select="compras/detalleCompras">
						<detalleCompras>
							<codSustento>
								<xsl:value-of select="codSustento" />
							</codSustento>
							<tpIdProv>
								<xsl:value-of select="tpIdProv" />
							</tpIdProv>
							<idProv>
								<xsl:value-of select="idProv" />
							</idProv>
							<tipoComprobante>
								<xsl:choose>
									<xsl:when test="string-length(normalize-space(tipoComprobante)) = 1">
										<xsl:value-of select="concat('0',normalize-space(tipoComprobante))" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="tipoComprobante" />
									</xsl:otherwise>
								</xsl:choose>
							</tipoComprobante>
							<fechaRegistro>
								<xsl:value-of select="fechaRegistro" />
							</fechaRegistro>
							<establecimiento>
								<xsl:value-of select="establecimiento" />
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision" />
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial" />
							</secuencial>
							<fechaEmision>
								<xsl:value-of select="fechaEmision" />
							</fechaEmision>
							<autorizacion>
								<xsl:value-of select="autorizacion" />
							</autorizacion>
							<baseNoGraIva>
								<xsl:value-of select="format-number(baseNoGraIva, '#0.00')" />
							</baseNoGraIva>
							<baseImponible>
								<xsl:value-of select="format-number(baseImponible, '#0.00')" />
							</baseImponible>
							<baseImpGrav>
								<xsl:value-of select="format-number(baseImpGrav, '#0.00')" />
							</baseImpGrav>
							<montoIce>
								<xsl:value-of select="format-number(montoIce, '#0.00')" />
							</montoIce>
							<montoIva>
								<xsl:value-of select="format-number(montoIva, '#0.00')" />
							</montoIva>
							<valorRetBienes>
								<xsl:value-of select="format-number(valorRetBienes, '#0.00')" />
							</valorRetBienes>
							<valorRetServicios>
								<xsl:value-of select="format-number(valorRetServicios, '#0.00')" />
							</valorRetServicios>
							<valRetServ100>
								<xsl:value-of select="format-number(valRetServ100, '#0.00')" />
							</valRetServ100>
							<xsl:if test="air">
								<air>
									<xsl:for-each select="air/detalleAir">
										<detalleAir>
											<codRetAir>
												<xsl:value-of select="codRetAir" />
											</codRetAir>
											<baseImpAir>
												<xsl:value-of select="format-number(baseImpAir, '#0.00')" />
											</baseImpAir>
											<porcentajeAir>
												<xsl:value-of select="format-number(porcentajeAir, '#0.00')" />
											</porcentajeAir>
											<valRetAir>
												<xsl:value-of select="format-number(valRetAir, '#0.00')" />
											</valRetAir>
										</detalleAir>
									</xsl:for-each>
								</air>
							</xsl:if>

							<xsl:if test="estabRetencion1">
								<xsl:if test="not(estabRetencion1 = '000')">
									<estabRetencion1>
										<xsl:value-of select="estabRetencion1" />
									</estabRetencion1>

									<ptoEmiRetencion1>
										<xsl:value-of select="ptoEmiRetencion1" />
									</ptoEmiRetencion1>

									<secRetencion1>
										<xsl:value-of select="secRetencion1" />
									</secRetencion1>

									<autRetencion1>
										<xsl:value-of select="autRetencion1" />
									</autRetencion1>

									<xsl:if test="not(fechaEmiRet1 = '00/00/0000')">
										<fechaEmiRet1>
											<xsl:value-of select="fechaEmiRet1" />
										</fechaEmiRet1>
									</xsl:if>
								</xsl:if>
							</xsl:if>

							<xsl:if test="docModificado">
								<xsl:if test="number(docModificado) > 0">
									<docModificado>
										<xsl:choose>
											<xsl:when test="string-length(normalize-space(docModificado)) = 1">
												<xsl:value-of select="concat('0',normalize-space(docModificado))" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="docModificado" />
											</xsl:otherwise>
										</xsl:choose>
									</docModificado>

									<estabModificado>
										<xsl:value-of select="estabModificado" />
									</estabModificado>

									<ptoEmiModificado>
										<xsl:value-of select="ptoEmiModificado" />
									</ptoEmiModificado>

									<secModificado>
										<xsl:value-of select="secModificado" />
									</secModificado>

									<autModificado>
										<xsl:value-of select="autModificado" />
									</autModificado>
								</xsl:if>
							</xsl:if>
						</detalleCompras>
					</xsl:for-each>
				</compras>
			</xsl:if>


			<xsl:if test="ventas">
				<ventas>
					<xsl:for-each select="ventas/detalleVentas">
						<detalleVentas>
							<tpIdCliente>
								<xsl:value-of select="tpIdCliente" />
							</tpIdCliente>
							<idCliente>
								<xsl:value-of select="idCliente" />
							</idCliente>
							<tipoComprobante>
								<xsl:choose>
									<xsl:when test="string-length(normalize-space(tipoComprobante)) = 1">
										<xsl:value-of select="concat('0',normalize-space(tipoComprobante))" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="tipoComprobante" />
									</xsl:otherwise>
								</xsl:choose>
							</tipoComprobante>
							<numeroComprobantes>
								<xsl:value-of select="numeroComprobantes" />
							</numeroComprobantes>
							<baseNoGraIva>
								<xsl:value-of select="format-number(baseNoGraIva, '#0.00')" />
							</baseNoGraIva>
							<baseImponible>
								<xsl:value-of select="format-number(baseImponible, '#0.00')" />
							</baseImponible>
							<baseImpGrav>
								<xsl:value-of select="format-number(baseImpGrav, '#0.00')" />
							</baseImpGrav>
							<montoIva>
								<xsl:value-of select="format-number(montoIva, '#0.00')" />
							</montoIva>
							<valorRetIva>
								<xsl:value-of select="format-number(valorRetIva, '#0.00')" />
							</valorRetIva>
							<valorRetRenta>
								<xsl:value-of select="format-number(valorRetRenta, '#0.00')" />
							</valorRetRenta>
						</detalleVentas>
					</xsl:for-each>
				</ventas>
			</xsl:if>

			<xsl:if test="exportaciones">
				<exportaciones>
					<xsl:for-each select="exportaciones/detalleExportaciones">
						<detalleExportaciones>
							<exportacionDe>
								<xsl:choose>
									<xsl:when test="string-length(normalize-space(exportacionDe)) = 1">
										<xsl:value-of select="concat('0',normalize-space(exportacionDe))" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="exportacionDe" />
									</xsl:otherwise>
								</xsl:choose>
							</exportacionDe>
							<tipoComprobante>
								<xsl:choose>
									<xsl:when test="string-length(normalize-space(tipoComprobante)) = 1">
										<xsl:value-of select="concat('0',normalize-space(tipoComprobante))" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="tipoComprobante" />
									</xsl:otherwise>
								</xsl:choose>
							</tipoComprobante>

							<xsl:if test="distAduanero">
								<distAduanero>
									<xsl:value-of select="distAduanero" />
								</distAduanero>
							</xsl:if>

							<xsl:if test="anio">
								<anio>
									<xsl:value-of select="anio" />
								</anio>
							</xsl:if>

							<xsl:if test="regimen">
								<regimen>
									<xsl:value-of select="regimen" />
								</regimen>
							</xsl:if>

							<xsl:if test="correlativo">
								<correlativo>
									<xsl:value-of select="correlativo" />
								</correlativo>
							</xsl:if>

							<xsl:if test="verificador">
								<verificador>
									<xsl:value-of select="verificador" />
								</verificador>
							</xsl:if>

							<xsl:if test="docTransp">
								<docTransp>
									<xsl:value-of select="docTransp" />
								</docTransp>
							</xsl:if>

							<fechaEmbarque>
								<xsl:value-of select="fechaEmbarque" />
							</fechaEmbarque>

							<xsl:if test="fue">
								<fue>
									<xsl:value-of select="fue" />
								</fue>
							</xsl:if>
							
							<valorFOB>
								<xsl:value-of select="format-number(valorFOB, '#0.00')" />
							</valorFOB>
							<valorFOBComprobante>
								<xsl:value-of select="format-number(valorFOBComprobante, '#0.00')" />
							</valorFOBComprobante>
							<establecimiento>
								<xsl:value-of select="establecimiento" />
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision" />
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial" />
							</secuencial>
							<autorizacion>
								<xsl:value-of select="autorizacion" />
							</autorizacion>
							<fechaEmision>
								<xsl:value-of select="fechaEmision" />
							</fechaEmision>
						</detalleExportaciones>
					</xsl:for-each>
				</exportaciones>
			</xsl:if>

			<xsl:if test="recap">
				<recap>
					<xsl:for-each select="recap/detalleRecap">
						<detalleRecap>
							<establecimientoRecap>
								<xsl:value-of select="establecimientoRecap" />
							</establecimientoRecap>
							<identificacionRecap>
								<xsl:value-of select="identificacionRecap" />
							</identificacionRecap>
							<tipoComprobante>
								<xsl:value-of select="tipoComprobante" />
							</tipoComprobante>
							<numeroRecap>
								<xsl:value-of select="numeroRecap" />
							</numeroRecap>
							<fechaPago>
								<xsl:value-of select="fechaPago" />
							</fechaPago>
							<tarjetaCredito>
								<xsl:value-of select="tarjetaCredito" />
							</tarjetaCredito>
							<fechaEmisionRecap>
								<xsl:value-of select="fechaEmisionRecap" />
							</fechaEmisionRecap>
							<consumoCero>
								<xsl:value-of select="format-number(consumoCero, '#0.00')" />
							</consumoCero>
							<consumoGravado>
								<xsl:value-of select="format-number(consumoGravado, '#0.00')" />
							</consumoGravado>
							<totalConsumo>
								<xsl:value-of select="format-number(totalConsumo, '#0.00')" />
							</totalConsumo>
							<montoIva>
								<xsl:value-of select="format-number(montoIva, '#0.00')" />
							</montoIva>
							<comision>
								<xsl:value-of select="format-number(comision, '#0.00')" />
							</comision>
							<numeroVouchers>
								<xsl:value-of select="numeroVouchers" />
							</numeroVouchers>
							<valorRetBienes>
								<xsl:value-of select="format-number(valorRetBienes, '#0.00')" />
							</valorRetBienes>
							<valorRetServicios>
								<xsl:value-of select="format-number(valorRetServicios, '#0.00')" />
							</valorRetServicios>
							<valRetServ100>
								<xsl:value-of select="format-number(valRetServ100, '#0.00')" />
							</valRetServ100>

							<xsl:if test="air">
								<air>
									<xsl:for-each select="air/detalleAir">
										<detalleAir>
											<codRetAir>
												<xsl:value-of select="codRetAir" />
											</codRetAir>
											<baseImpAir>
												<xsl:value-of select="format-number(baseImpAir, '#0.00')" />
											</baseImpAir>
											<porcentajeAir>
												<xsl:value-of select="format-number(porcentajeAir, '#0.00')" />
											</porcentajeAir>
											<valRetAir>
												<xsl:value-of select="format-number(valRetAir, '#0.00')" />
											</valRetAir>
										</detalleAir>
									</xsl:for-each>
								</air>
							</xsl:if>

							<establecimiento>
								<xsl:value-of select="establecimiento" />
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision" />
							</puntoEmision>
							<secuencial>
								<xsl:value-of select="secuencial" />
							</secuencial>
							<autorizacion>
								<xsl:value-of select="autorizacion" />
							</autorizacion>
							<fechaEmision>
								<xsl:value-of select="fechaEmision" />
							</fechaEmision>
						</detalleRecap>
					</xsl:for-each>
				</recap>
			</xsl:if>

			<xsl:if test="fideicomisos">
				<fideicomisos>
					<xsl:for-each select="fideicomisos/detalleFideicomisos">
						<detalleFideicomisos>
							<tipoBeneficiario>
								<xsl:value-of select="tipoBeneficiario" />
							</tipoBeneficiario>
							<idBeneficiario>
								<xsl:value-of select="idBeneficiario" />
							</idBeneficiario>
							<rucFideicomiso>
								<xsl:value-of select="rucFideicomiso" />
							</rucFideicomiso>

							<fValor>
								<xsl:for-each select="fValor/detallefValor">
									<detallefValor>
										<tipoFideicomiso>
											<xsl:value-of select="tipoFideicomiso" />
										</tipoFideicomiso>
										<totalF>
											<xsl:value-of select="format-number(totalF, '#0.00')" />
										</totalF>
										<individualF>
											<xsl:value-of select="format-number(individualF, '#0.00')" />
										</individualF>
										<porRetF>
											<xsl:value-of select="format-number(porRetF, '#0.00')" />
										</porRetF>
										<valorRetF>
											<xsl:value-of select="format-number(valorRetF, '#0.00')" />
										</valorRetF>
									</detallefValor>
								</xsl:for-each>
							</fValor>
						</detalleFideicomisos>
					</xsl:for-each>
				</fideicomisos>
			</xsl:if>

			<xsl:if test="anulados">
				<anulados>
					<xsl:for-each select="anulados/detalleAnulados">
						<detalleAnulados>
							<tipoComprobante>
								<xsl:choose>
									<xsl:when test="string-length(normalize-space(tipoComprobante)) = 1">
										<xsl:value-of select="concat('0',normalize-space(tipoComprobante))" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="tipoComprobante" />
									</xsl:otherwise>
								</xsl:choose>
							</tipoComprobante>

							<establecimiento>
								<xsl:value-of select="establecimiento" />
							</establecimiento>
							<puntoEmision>
								<xsl:value-of select="puntoEmision" />
							</puntoEmision>
							<secuencialInicio>
								<xsl:value-of select="secuencialInicio" />
							</secuencialInicio>
							<secuencialFin>
								<xsl:value-of select="secuencialFin" />
							</secuencialFin>
							<autorizacion>
								<xsl:value-of select="autorizacion" />
							</autorizacion>
						</detalleAnulados>
					</xsl:for-each>
				</anulados>
			</xsl:if>

			<xsl:if test="rendFinancieros">
				<rendFinancieros>
					<xsl:for-each select="rendFinancieros/detalleRendFinancieros">
						<detalleRendFinancieros>
							<retenido>
								<xsl:value-of select="retenido" />
							</retenido>
							<idRetenido>
								<xsl:value-of select="idRetenido" />
							</idRetenido>

							<xsl:if test="ahorroPN">
								<ahorroPN>
									<totalDep>
										<xsl:value-of select="format-number(ahorroPN/totalDep, '#0.00')" />
									</totalDep>
									<rendGen>
										<xsl:value-of select="format-number(ahorroPN/rendGen, '#0.00')" />
									</rendGen>
								</ahorroPN>
							</xsl:if>

							<xsl:if test="ctaExenta">
								<ctaExenta>
									<totalDep>
										<xsl:value-of select="format-number(ctaExenta/totalDep, '#0.00')" />
									</totalDep>
									<rendGen>
										<xsl:value-of select="format-number(ctaExenta/rendGen, '#0.00')" />
									</rendGen>
								</ctaExenta>
							</xsl:if>

							<xsl:if test="retenciones">
								<retenciones>
									<xsl:for-each select="retenciones/detRet">
										<detRet>
											<estabRetencion>
												<xsl:value-of select="estabRetencion" />
											</estabRetencion>
											<ptoEmiRetencion>
												<xsl:value-of select="ptoEmiRetencion" />
											</ptoEmiRetencion>
											<secRetencion>
												<xsl:value-of select="secRetencion" />
											</secRetencion>
											<autRetencion>
												<xsl:value-of select="autRetencion" />
											</autRetencion>
											<fechaEmiRet>
												<xsl:value-of select="fechaEmiRet" />
											</fechaEmiRet>

											<airRend>
												<xsl:for-each select="airRend/detalleAirRen">
													<detalleAirRen>
														<codRetAir>
															<xsl:value-of select="codRetAir" />
														</codRetAir>
														<deposito>
															<xsl:value-of select="format-number(deposito, '#0.00')" />
														</deposito>
														<baseImpAir>
															<xsl:value-of select="format-number(baseImpAir, '#0.00')" />
														</baseImpAir>
														<porcentajeAir>
															<xsl:value-of select="format-number(porcentajeAir, '#0.00')" />
														</porcentajeAir>
														<valRetAir>
															<xsl:value-of select="format-number(valRetAir, '#0.00')" />
														</valRetAir>
													</detalleAirRen>
												</xsl:for-each>
											</airRend>
										</detRet>
									</xsl:for-each>
								</retenciones>
							</xsl:if>
						</detalleRendFinancieros>
					</xsl:for-each>
				</rendFinancieros>

			</xsl:if>
		</iva>
	</xsl:template>

</xsl:stylesheet>